/********************************************************************
             A Golog/Prolog - Tekkotsu Interface
                        August, 2006.                 

            Do not distribute without permission.
            Include this notice in any copy made.

Permission to use, copy, and modify this software and its documentation 
for non-commercial research purpose is hereby granted without fee,
provided that this permission notice appears in all copies. This
software cannot be used for commercial purposes without written permission.
This software is provided "as is" without express or implied warranty
(including all implied warranties of merchantability and fitness).
No liability is implied for any damages resulting from 
or in connection with the use or performance of this software.

E-mail questions/comments about the interface to Huy Pham:
            hpham [at] scs [dot] ryerson [dot] ca   

Implementation environment:
This interface requires Eclipse Prolog:
	http://eclipse.crosscoreop.com/eclipse/index.html

**********************************************************************/


#ifndef TCPComm_h_DEFINED
#define TCPComm_h_DEFINED

// Port on which the GTI server listens for commands
#define GTI_PORT	12345

// Command Header Types
enum CmdHdrType {
	CMDHDR_READ,
	CMDHDR_QUERYBALL,
	CMDHDR_SEARCHBALL,
	CMDHDR_MOVE,
	CMDHDR_MSEQ,
	CMDHDR_WALK,
	CMDHDR_TURN,
	CMDHDR_SOUND,
	CMDHDR_DEBUG
};

enum WalkCmdType {
	WALKTYPE_FIXED,
	WALKTYPE_START,
	WALKTYPE_END	
};

enum TurnCmdType {
	TURNTYPE_FIXED,
	TURNTYPE_START,
	TURNTYPE_END	
};

// TCP Command Header
struct CmdHdr{
	int type;		
	int len;		
};

struct JointCmd{
	int joint;
	int angle;	
};

struct SensorCmd{
	int sensor;	
};

struct WalkParam{
	double dx;
	double dy;
	int type; 
};

struct TurnParam{
	double da;
	int type;	
};

struct Ball{
	double visible;   
	double xcoord;
	double ycoord;
	double area;	
};

#endif

