
#ifndef INCLUDED_GtiMC_h_
#define INCLUDED_GtiMC_h_

#include "Motion/MotionCommand.h"
#include "ERS7.h"

class GtiMC : public MotionCommand {

public:
	GtiMC() : MotionCommand(){
		for (int i = 0; i < ERS7_NUM_OUTPUTS; i++)
			pendingAngles[i] = 0;
		updateCurrentAngles();
		radPerFrame = 0.02;
	}

	virtual int updateOutputs() {
		
		// OutputCmd outputCmds[NumFrames];
		for (int i = 0; i < ERS7_NUM_OUTPUTS; i++){
			
			bool must_update = false;
			OutputCmd outputCmds[NumFrames];
			
			// Populate the 4 frames for this output
			for (int j = 0; j < (int) NumFrames; j++){
				if (pendingAngles[i] < 0){
					// cout << "updateOutputs(): Joint = " << i <<  " Current = " << currentAngles[i] << " Pending = " << pendingAngles[i] << endl;
					must_update = true;
					if(pendingAngles[i] < - radPerFrame){
						//
						// Check Angle Limit here
						//
						outputCmds[j].set((float)(currentAngles[i] - radPerFrame), 1);
						currentAngles[i] = currentAngles[i] - radPerFrame;
						pendingAngles[i] = pendingAngles[i] + radPerFrame;
					}
					else{
						//
						// Check Angle Limit here
						//
						outputCmds[j].set((float)(currentAngles[i] + pendingAngles[i]), 1);
						currentAngles[i] = currentAngles[i] + pendingAngles[i];
						pendingAngles[i] = 0;
					}
				}
				else if (pendingAngles[i] > 0){
					// cout << "updateOutputs(): Joint = " << i <<  " Current = " << currentAngles[i] << " Pending = " << pendingAngles[i] << endl;
					must_update = true;
					if(pendingAngles[i] > radPerFrame){
						//
						// Check Angle Limit here
						//
						outputCmds[j].set((float)(currentAngles[i] + radPerFrame), 1);
						currentAngles[i] = currentAngles[i] + radPerFrame;
						pendingAngles[i] = pendingAngles[i] - radPerFrame;
					}
					else{
						//
						// Check Angle Limit here
						//
						outputCmds[j].set((float)(currentAngles[i] + pendingAngles[i]), 1);
						currentAngles[i] = currentAngles[i] + pendingAngles[i];
						pendingAngles[i] = 0;
					}
				}
				else{
					outputCmds[j].set((float) currentAngles[i], 1);	
				}
			}
			
			// But update the output ONLY if it has to be moved
			if(must_update){
				motman->setOutput(this, i, outputCmds);
			}
				
		}
		
		return 1;
	}
	
	virtual int isDirty() {
		return true;
	}
	
	virtual int isAlive() {
		return true;
	}
	
	void updatePendingAngles(struct AngleArray aa){
		for (int i = 0; i < ERS7_NUM_OUTPUTS; i++){
			if (aa.angles[i] != 0){
				pendingAngles[i] = aa.angles[i] * 3.1416 / 180; 	
			}
		}
	}
	
	void updateCurrentAngles(){
		for (int i = 0; i < ERS7_NUM_OUTPUTS; i++){
			currentAngles[i] = state->outputs[i];
		}	
	}
	
	// These 2 need to be cleaned up
	void increaseMaxSpeed(){
		radPerFrame += 0.01;
		cout << "GtiMC: radPerFrame = " << radPerFrame << endl;
	}	
	void decreaseMaxSpeed(){
		radPerFrame -= 0.01;
		cout << "GtiMC: radPerFrame = " << radPerFrame << endl;
	}
	
	void setRadPerFrame(int output, double rpf){
		// 
		// Check angular speed limit here
		// 
		// radPerFrame[output] = rpf;
	}
	void setRadPerFrame(double rpf){
		for(int i = 0; i < ERS7_NUM_OUTPUTS; i++){
			setRadPerFrame(i, rpf);
		}
	}
	
private:
	double radPerFrame;
	double pendingAngles[ERS7_NUM_OUTPUTS]; // Rad
	double currentAngles[ERS7_NUM_OUTPUTS]; // Rad
	
};

#endif
