
#ifndef INCLUDED_GtiBehavior_h_
#define INCLUDED_GtiBehavior_h_

#include <vector>
#include <string>

#include "Behaviors/BehaviorBase.h"

#include "Events/EventRouter.h"
#include "Events/TextMsgEvent.h"
#include "Events/VisionObjectEvent.h"

#include "Shared/ProjectInterface.h"
#include "Shared/WorldState.h"
#include "Shared/mathutils.h"

#include "Wireless/Wireless.h"

#include "Motion/MotionManager.h"
#include "Motion/MMAccessor.h"
#include "Motion/LedMC.h"
#include "Motion/WalkMC.h"
#include "Motion/MotionSequenceMC.h"
#include "Sound/SoundManager.h"

#include "GtiMC.h"
#include "GtiHeadMC.h"
#include "TCPComm.h"
#include "ERS7.h"


#define WALK_DX 100	// mm/second
#define WALK_DY 100	// mm/second
#define WALK_DA 1	// rad/second



// What ctrlsvr is expecting to recieve
enum ReceivingState{
	RECEIVING_CMDHDR,
	RECEIVING_JLIST,
	RECEIVING_SLIST,
	RECEIVING_WALKPARAM,
	RECEIVING_TURNPARAM,
	RECEIVING_MOTSEQ,
	RECEIVING_BALLQUERY,
	RECEIVING_BALLSEARCH,
	RECEIVING_SOUNDFILE
};


class GtiBehavior : public BehaviorBase {

public:

	static GtiBehavior * theOne;
	
	GtiBehavior();
	~GtiBehavior();

	virtual void DoStart();
	virtual void DoStop();
	virtual void processEvent(const EventBase& event);
	
	static int processNetwork(char *buf, int bytes);
	
	static std::string getClassDescription() { return "A Golog-Tekkotsu interface"; }
	virtual std::string getDescription() const { return getClassDescription(); }
	
	void setWalkHeight(int mm);
	static double max(double a, double b);
	static bool ballWithinSight(int ball);
	static void lockOnBall(int ball);
	static double deg(double r);
	static double rad(double r);
	
	
protected:
	static class Socket * socket;
	static int sock;
	static ReceivingState rcvState;
	
	MotionManager::MC_ID gtiMC_id;
	MotionManager::MC_ID gtiHeadMC_id;
	MotionManager::MC_ID ledMC_id;
	MotionManager::MC_ID walkMC_id;
	
	
private:
	GtiBehavior(const GtiBehavior&); 
	GtiBehavior& operator = (const GtiBehavior&);
	
	int walkHeight; // mm
	int walkAngle; // deg
	
	// struct Ball pinkBall;
	// struct Ball blueBall;
	// struct Ball yellowBall;
	// struct Ball greenBall;
	
	struct Ball balls[4];	// Pink, Blue, Yellow, Green
	
	int sectorCount;
	int searchingBall;
	
};

/*! @GtiBehavior
 * @brief Defines GtiBehavior, which implements a Golog-Tekkotsu interface
 * @author Mikhail Soutchanski, Huy Pham
 *
 */

#endif
