
#include "GtiBehavior.h"

using namespace std;


ReceivingState GtiBehavior::rcvState;
class Socket * GtiBehavior::socket;
int GtiBehavior::sock;
GtiBehavior* GtiBehavior::theOne = NULL;

GtiBehavior::GtiBehavior() : BehaviorBase("GtiBehavior"){
	
	theOne=this;
	gtiMC_id = MotionManager::invalid_MC_ID;
	gtiHeadMC_id = MotionManager::invalid_MC_ID;
	ledMC_id = MotionManager::invalid_MC_ID;
	walkMC_id = MotionManager::invalid_MC_ID;
}

GtiBehavior::~GtiBehavior() {
	
	theOne=NULL;
}

void GtiBehavior::DoStart() {
	
	BehaviorBase::DoStart();

	rcvState = RECEIVING_CMDHDR;
	balls[0].visible = false;
	balls[1].visible = false;
	balls[2].visible = false;
	balls[3].visible = false;
	
	socket = wireless->socket(SocketNS::SOCK_STREAM);
	sock = socket->sock;
	wireless->setDaemon(socket, true);
	wireless->setReceiver(socket->sock, GtiBehavior::processNetwork);
	wireless->listen(socket->sock, GTI_PORT);

	gtiMC_id = motman->addPersistentMotion(SharedObject<GtiMC>());
	gtiHeadMC_id = motman->addPersistentMotion(SharedObject<GtiHeadMC>());
	ledMC_id = motman->addPersistentMotion(SharedObject<LedMC>());
	walkMC_id = motman->addPersistentMotion(SharedObject<WalkMC>());
	
	erouter->addListener(this, EventBase::textmsgEGID);
	erouter->addListener(this, EventBase::visObjEGID, ProjectInterface::visPinkBallSID);
	erouter->addListener(this, EventBase::visObjEGID, ProjectInterface::visBlueBallSID);
	
	/*
	erouter->addListener(this, EventBase::visObjEGID, ProjectInterface::visYellowBallSID);
	erouter->addListener(this, EventBase::visObjEGID, ProjectInterface::visGreenBallSID);
	*/
	
	erouter->addListener(this, EventBase::motmanEGID, gtiHeadMC_id, EventBase::statusETID);
	
	cout << endl;
	cout << "GtiBehavior - A Golog-Tekkotsu Interface behavior" << endl;
	cout << "Mikhail Soutchanski, Huy Pham" << endl;
	cout << "2006" << endl;
	cout << endl;
	
}

void GtiBehavior::DoStop() {
	
	erouter->removeListener(this);
	
	wireless->setDaemon(socket, false);
	wireless->close(socket);
	if(socket != NULL && wireless->isConnected(sock))
		wireless->close(socket);
	socket = NULL;
	
	motman->removeMotion(gtiMC_id);
	motman->removeMotion(ledMC_id);
	motman->removeMotion(walkMC_id);
	
	BehaviorBase::DoStop(); 
	
}

void GtiBehavior::processEvent(const EventBase& event) {
	
	switch ( event.getGeneratorID() ) {

		case EventBase::visObjEGID: {
			const VisionObjectEvent &visev = dynamic_cast<const VisionObjectEvent&>(event);
			if ( visev.getTypeID() == EventBase::activateETID || visev.getTypeID() == EventBase::statusETID ){
				if(visev.getSourceID() == ProjectInterface::visPinkBallSID){
					balls[0].xcoord = visev.getCenterX();
					balls[0].ycoord = visev.getCenterY();
					balls[0].area = visev.getObjectArea();
					balls[0].visible = 1;
					cout << "PINK" << endl;
				}
				else if(visev.getSourceID() == ProjectInterface::visBlueBallSID){
					balls[1].xcoord = visev.getCenterX();
					balls[1].ycoord = visev.getCenterY();
					balls[1].area = visev.getObjectArea();
					balls[1].visible = 1;
					cout << "BLUE" << endl;
				}
				
				/*
				
				else if(visev.getSourceID() == ProjectInterface::visYellowBallSID){
					balls[2].xcoord = visev.getCenterX();
					balls[2].ycoord = visev.getCenterY();
					balls[2].area = visev.getObjectArea();
					balls[2].visible = 1;
					cout << "YELLOW" << endl;
				}
				else if(visev.getSourceID() == ProjectInterface::visGreenBallSID){
					balls[3].xcoord = visev.getCenterX();
					balls[3].ycoord = visev.getCenterY();
					balls[3].area = visev.getObjectArea();
					balls[3].visible = 1;
					cout << "GREEN" << endl;
				}
				*/
				
			}	
			else{
				if(visev.getSourceID() == ProjectInterface::visPinkBallSID)
					balls[0].visible = 0;
				else if(visev.getSourceID() == ProjectInterface::visBlueBallSID)
					balls[1].visible = 0;
				
				/*
				else if(visev.getSourceID() == ProjectInterface::visYellowBallSID)
					balls[2].visible = 0;
				else if(visev.getSourceID() == ProjectInterface::visGreenBallSID)
					balls[3].visible = 0;
				*/
			}
			
			break;
		};
		
		case EventBase::textmsgEGID: {
			cout << "text event" << endl;
			
			const TextMsgEvent &txtev = dynamic_cast<const TextMsgEvent&>(event);
			cout << "Gti: Recieved '" << txtev.getText() << "'" << endl;
			
			if(txtev.getText().compare("incrRPF") == 0){
				MMAccessor<GtiMC> gti_mc(theOne->gtiMC_id);
				gti_mc->increaseMaxSpeed();
			}
			else if(txtev.getText().compare("decrRPF") == 0){
				MMAccessor<GtiMC> gti_mc(theOne->gtiMC_id);
				gti_mc->decreaseMaxSpeed();
			}
			
			break; 
		};
		
		case EventBase::buttonEGID: {
			std::cout << "Dst got event: " << event.getDescription() << std::endl;
			
			break;
		};
			
		case EventBase::timerEGID: {
			MMAccessor<WalkMC> walk_mc(theOne->walkMC_id);
			walk_mc->setTargetVelocity(0, 0, 0);	
			
			// Send walk/turn completion signal back to the client
			int signal = 1;
			if(socket != NULL) {
				if(wireless->isConnected(sock))
					socket->write((byte*) &signal, sizeof(int));
				else if(!socket->getDaemon())
					socket=NULL;
			}
			
			// DBG
			cout << "Walk/turn completed." << endl;
			
			break;
		};
		
		case EventBase::motmanEGID: {
			if(ballWithinSight(searchingBall)){
				
				// DBG
				cout << "processEvent: Found ball!" << endl;
				
				// Stop sector scanning
				sectorCount = 0;

				// Fine tune the head to center on the ball				
				MMAccessor<GtiHeadMC> gti_head_mc(theOne->gtiHeadMC_id);
				if((balls[searchingBall].ycoord > 0.1) && \
				   (deg(gti_head_mc->getCurrentAngle(NOD)) > -10)){
					// DBG
					cout << "processEvent: Correcting Nod " << balls[searchingBall].ycoord << " -> Nod down (Neg)" <<  endl;
					// gti_head_mc->updateCurrentAngles();
					gti_head_mc->nod(-1);
				}
				else if((balls[searchingBall].ycoord < -0.1) && \
				   (deg(gti_head_mc->getCurrentAngle(NOD)) < 40)){
					// DBG
					cout << "processEvent: Correcting Nod " << balls[searchingBall].ycoord << " -> Nod up (Pos)" <<  endl;
					// gti_head_mc->updateCurrentAngles();
					gti_head_mc->nod(1);
				}
				else if((balls[searchingBall].xcoord > 0.1) && \
				   (deg(gti_head_mc->getCurrentAngle(PAN)) > -75)){
					// DBG
					cout << "processEvent: Correcting Pan " << balls[searchingBall].xcoord << " -> Pan right (Neg)" <<  endl;
					// gti_head_mc->updateCurrentAngles();
					gti_head_mc->pan(-1);
				}
				else if((balls[searchingBall].xcoord < -0.1) && \
				   (deg(gti_head_mc->getCurrentAngle(PAN)) < 75)){
					cout << "processEvent: Correcting Pan " << balls[searchingBall].xcoord << " -> Pan left (Pos)" <<  endl;
					// gti_head_mc->updateCurrentAngles();
					gti_head_mc->pan(1);
				}
				else{
					cout << "processEvent: No fine tuning neccessary, returning success signal" << endl; 
					int signal = 1;
					if(socket != NULL) {
						if(wireless->isConnected(sock))
							socket->write((byte*) &signal, sizeof(int));
						else if(!socket->getDaemon())
							socket=NULL;
					}
				}
			}
			else if(sectorCount > 0){
			 	// DBG
				// cout << "processEvent: SectorCount = " << sectorCount << ", continue to find ball!" << endl;
				
				sectorCount--;
				MMAccessor<GtiHeadMC> gti_head_mc(theOne->gtiHeadMC_id);
				gti_head_mc->scanSector();
			}
			else{
			 	// DBG
				cout << "processEvent: SectorCount = " << sectorCount << ". Ball not found" << endl;
				
				// Send failure signal back to the client
				int signal = 0;
				if(socket != NULL) {
					if(wireless->isConnected(sock))
						socket->write((byte*) &signal, sizeof(int));
					else if(!socket->getDaemon())
						socket=NULL;
				}
			}
			
			break; 
		};
		
		default:
			std::cout << "Gti: Unexpected event: " << event.getDescription() << std::endl;
			
	}
}

int GtiBehavior::processNetwork(char *buf, int bytes) {
	
	if (rcvState == RECEIVING_CMDHDR){
		
		// cout << "GtiBehavior: Received " << bytes << " bytes as CmdHdr" << endl;
		
		struct CmdHdr * hdr = (struct CmdHdr *) buf;
		// cout << "GtiBehavior: Hdr type = " << hdr->type << ", Hdr length = " << hdr->len << endl; 
		
		if (hdr->type == CMDHDR_MOVE)
			rcvState = RECEIVING_JLIST;
		else if (hdr->type == CMDHDR_READ)
			rcvState = RECEIVING_SLIST;
		else if (hdr->type == CMDHDR_WALK)
			rcvState = RECEIVING_WALKPARAM;
		else if (hdr->type == CMDHDR_MSEQ)
			rcvState = RECEIVING_MOTSEQ;
		else if (hdr->type == CMDHDR_QUERYBALL)
			rcvState = RECEIVING_BALLQUERY;
		else if (hdr->type == CMDHDR_SEARCHBALL)
			rcvState = RECEIVING_BALLSEARCH;
		else if (hdr->type == CMDHDR_TURN)
			rcvState = RECEIVING_TURNPARAM;
		else if (hdr->type == CMDHDR_SOUND)
			rcvState = RECEIVING_SOUNDFILE;
		else if (hdr->type == CMDHDR_DEBUG){
			
			MMAccessor<GtiHeadMC> gti_head_mc(theOne->gtiHeadMC_id);
			gti_head_mc->scanSector();
			
			rcvState = RECEIVING_CMDHDR;
		}
		else
			cout << "GtiBehavior: Invalid header type encountered." << endl; 	
		
	}
	else if (rcvState == RECEIVING_JLIST){
		
		cout << "GtiBehavior: Received " << bytes << " bytes of JointCmd structures" << endl;
		
		int cmdcnt = bytes / sizeof(struct JointCmd);
		struct JointCmd *jointCmds = (struct JointCmd *) buf;
		
		struct AngleArray angarr;
		for (int i = 0; i < ERS7_NUM_OUTPUTS; i++)
			angarr.angles[i] = 0;	
				
		for(int i = 0; i < cmdcnt; i++){
			angarr.angles[jointCmds[i].joint] = jointCmds[i].angle;
			// DBG
			cout << "     Moving: Output " << jointCmds[i].joint << " " << jointCmds[i].angle << " degrees" << endl;
		}
		
		MMAccessor<GtiMC> gti_mc(theOne->gtiMC_id);
      		gti_mc->updateCurrentAngles();
      		gti_mc->updatePendingAngles(angarr);
		
		// Send update completion signal back to the client
		int signal = 1;
		if(socket != NULL) {
			if(wireless->isConnected(sock))
				socket->write((byte*) &signal, sizeof(int));
			else if(!socket->getDaemon())
				socket=NULL;
		}
		
		rcvState = RECEIVING_CMDHDR;
		
	}
	else if (rcvState == RECEIVING_SLIST){
		
		cout << "GtiBehavior: Received " << bytes << " bytes of SensorCmd structures" << endl;
		
		int sensorcnt = bytes / sizeof(struct SensorCmd);
		struct SensorCmd *sensorCmds = (struct SensorCmd *) buf;
		double values[sensorcnt];
			
		// Gather all the requested values
		for(int i = 0; i < sensorcnt; i++){
			if (sensorCmds[i].sensor < ERS7_NUM_OUTPUTS) {
				values[i] = (double) state->outputs[sensorCmds[i].sensor] * 180 / 3.1416;
				cout << "     Reading: Output " << sensorCmds[i].sensor << " has value " << values[i] << endl;
			}
			else if (sensorCmds[i].sensor < ERS7_NUM_OUTPUTS + ERS7_NUM_SENSORS) {
				values[i] = (double) state->sensors[sensorCmds[i].sensor - ERS7_NUM_OUTPUTS];
				cout << "     Reading: Sensor " << sensorCmds[i].sensor - ERS7_NUM_OUTPUTS << " has value " << values[i] << endl;
			}
			else if (sensorCmds[i].sensor < ERS7_NUM_OUTPUTS + ERS7_NUM_SENSORS + ERS7_NUM_BUTTONS) {
				values[i] = (double) state->buttons[sensorCmds[i].sensor - (ERS7_NUM_OUTPUTS + ERS7_NUM_SENSORS)];
				cout << "     Reading: Button " << sensorCmds[i].sensor - (ERS7_NUM_OUTPUTS + ERS7_NUM_SENSORS) << " has value " << values[i] << endl;
			}
			else{
				cout << "GtiBehavior: Invalide read index encoutered in processNetwork()" << endl;	
			}
		}
	
		// Send them
		if(socket != NULL) {
			if(wireless->isConnected(sock))
				socket->write((byte*)values, sensorcnt * sizeof(double));
			else if(!socket->getDaemon())
				socket=NULL;
		}
		
		rcvState = RECEIVING_CMDHDR;
	}
	else if (rcvState == RECEIVING_BALLQUERY){
		
		int *idx = (int *) buf;
		
		// Send the Ball structure back to client
		if(socket != NULL) {
			if(wireless->isConnected(sock))
				socket->write((byte*) &(theOne->balls[*idx]), sizeof(struct Ball));
			else if(!socket->getDaemon())
				socket=NULL;
		}
		
		rcvState = RECEIVING_CMDHDR;
	}
	else if (rcvState == RECEIVING_BALLSEARCH){
		
		int *idx = (int *) buf;
		// int b = theOne->searchingBall;
				
		if(ballWithinSight(*idx)){
			
			// Fine tuning the head to center on the ball, if neccessary
			MMAccessor<GtiHeadMC> gti_head_mc(theOne->gtiHeadMC_id);
			if((theOne->balls[*idx].ycoord > 0.1) && \
			   (deg(gti_head_mc->getCurrentAngle(NOD)) > -10)){
				gti_head_mc->updateCurrentAngles();
				gti_head_mc->nod(-1);
			}
			else if((theOne->balls[*idx].ycoord < -0.1) && \
			   (deg(gti_head_mc->getCurrentAngle(NOD)) < 40)){
				gti_head_mc->updateCurrentAngles();
				gti_head_mc->nod(1);
			}
			else if((theOne->balls[*idx].xcoord > 0.1) && \
			   (deg(gti_head_mc->getCurrentAngle(PAN)) > -75)){
				gti_head_mc->updateCurrentAngles();
				gti_head_mc->pan(-1);
			}
			else if((theOne->balls[*idx].xcoord < -0.1) && \
			   (deg(gti_head_mc->getCurrentAngle(PAN)) < 75)){
				gti_head_mc->updateCurrentAngles();
				gti_head_mc->pan(1);
			}
			else{
				// If no fine tuning is needed,
				// send success signal back to the client
				int signal = 1;
				if(socket != NULL) {
					if(wireless->isConnected(sock))
						socket->write((byte*) &signal, sizeof(int));
					else if(!socket->getDaemon())
						socket=NULL;
				}
			}
		}
		else{
			theOne->sectorCount = 50;
			theOne->searchingBall = *idx;
			MMAccessor<GtiHeadMC> gti_head_mc(theOne->gtiHeadMC_id);
			gti_head_mc->updateCurrentAngles();
			gti_head_mc->scanSector();
		}
		
		rcvState = RECEIVING_CMDHDR;
	}
	else if (rcvState == RECEIVING_WALKPARAM){
	
		struct WalkParam *wp = (struct WalkParam *) buf;
		
		if (wp->type == WALKTYPE_FIXED){
			// The amount of time needed to achieve this vector
			int t =  (int) ceil(max(fabs(wp->dx / WALK_DX), fabs(wp->dy / WALK_DY)));
			// cout << "Walk: t=" << t << " dx=" << wp->dx / t << " dy=" << wp->dy / t << endl;
			
			// Now walk for t seconds in the direction of the vector scaled down by the factor t
			MMAccessor<WalkMC> walk_mc(theOne->walkMC_id);
			walk_mc->setTargetVelocity(wp->dx / t, wp->dy / t, 0);
			erouter->addTimer(theOne, 0, t * 1000, false);
		}
		else if (wp->type == WALKTYPE_START){
			MMAccessor<WalkMC> walk_mc(theOne->walkMC_id);
			// walk_mc->setAngle(0);
			walk_mc->setTargetVelocity(wp->dx, wp->dy, 0);	
		}
		else if (wp->type == WALKTYPE_END){
			MMAccessor<WalkMC> walk_mc(theOne->walkMC_id);
			// walk_mc->setAngle(0);
			walk_mc->setTargetVelocity(0, 0, 0);	
		}
		
		rcvState = RECEIVING_CMDHDR;
	}
	else if (rcvState == RECEIVING_MOTSEQ){
		
		string filename((char *) buf);
		SharedObject<LargeMotionSequenceMC> mseq_mc(filename);
		motman->addPrunableMotion(mseq_mc);
		
		rcvState = RECEIVING_CMDHDR;
	}
	else if (rcvState == RECEIVING_TURNPARAM){
		struct TurnParam *tp = (struct TurnParam *) buf;
		
		if (tp->type == TURNTYPE_FIXED){
			// The amount of time needed to achieve this angle
			int t =  (int) ceil(fabs((tp->da * 3.1416/180) / WALK_DA));
			
			// Now turn for t seconds
			MMAccessor<WalkMC> walk_mc(theOne->walkMC_id);
			walk_mc->setTargetVelocity(0, 0, (tp->da * 3.1416/180) / t);
			erouter->addTimer(theOne, 0, t * 1000, false);
		}
		else if (tp->type == TURNTYPE_START){
			MMAccessor<WalkMC> walk_mc(theOne->walkMC_id);
			walk_mc->setTargetVelocity(0, 0, tp->da * 3.1416/180);	
		}
		else if (tp->type == TURNTYPE_END){
			MMAccessor<WalkMC> walk_mc(theOne->walkMC_id);
			walk_mc->setTargetVelocity(0, 0, 0);	
		}
		
		rcvState = RECEIVING_CMDHDR;
	}
	else if (rcvState == RECEIVING_SOUNDFILE){
		
		string filename((char *) buf);
		// sndman->LoadFile(filename);
		sndman->PlayFile(filename);
		
		rcvState = RECEIVING_CMDHDR;
	}
	else{
		cout << "GtiBehavior: ERROR: processNetwork() encounter unexpected state" << endl;	
	}
	
	return 0;
}

bool GtiBehavior::ballWithinSight(int ball){
	
	// double visible;
	// if (ball == 0)
	// 	visible = theOne->pinkBall.visible;
	// else if (ball == 1)
	// 	visible = theOne->blueBall.visible;
	// else if (ball == 2)
	// 	visible = theOne->yellowBall.visible;
	// else if (ball == 3)
	// 	visible = theOne->greenBall.visible;
	// else
	// 	visible = 0;
	
	if(theOne->balls[ball].visible)
		return true;
	else
		return false;
	
}

// void GtiBehavior::lockOnBall(int ball){
	// if (ballWithinSight(ball)){
	// 	struct Ball b;
	// 	if (ball == 0)
	// 		b = theOne->pinkBall;
	// 	else if (ball == 1)
	// 		b = theOne->blueBall;
	// 	else if (ball == 2)
	// 		b = theOne->yellowBall;
	// 	else if (ball == 3)
	// 		b = theOne->greenBall;
		
	// 	while (fabs(b.xcoord) > 0.2){
	// 		if(b.xcoord < 0){
				
	// 		}	
	// 	}	
		
	// }	
// 	return;	
// }

void GtiBehavior::setWalkHeight(int mm) {
	
	walkHeight = mm;
}

double GtiBehavior::max(double a, double b) {
	
	double tmp = a;
	if (tmp < b) tmp = b;
	return tmp;
}	
	
double GtiBehavior::deg(double r){
		return r * 180 / 3.1416;	
	}
	
double GtiBehavior::rad(double d){
	return d * 3.1416 / 180;	
}	
