/********************************************************************
             A Golog/Prolog - Tekkotsu Interface
                        August, 2006.                 

            Do not distribute without permission.
            Include this notice in any copy made.

Permission to use, copy, and modify this software and its documentation 
for non-commercial research purpose is hereby granted without fee,
provided that this permission notice appears in all copies. This
software cannot be used for commercial purposes without written permission.
This software is provided "as is" without express or implied warranty
(including all implied warranties of merchantability and fitness).
No liability is implied for any damages resulting from 
or in connection with the use or performance of this software.

E-mail questions/comments about the interface to Huy Pham:
            hpham [at] scs [dot] ryerson [dot] ca   

Implementation environment:
This interface requires Eclipse Prolog:
	http://eclipse.crosscoreop.com/eclipse/index.html

**********************************************************************/




//////////////////////////////////////////////////////////////////////
//
// ERS7.h
//
// ERS7 primitive names and locators
// 
// Compiled from Sony's ERS-7 Model Information document and
// various ERS-7 sample programs
//
//
//
//////////////////////////////////////////////////////////////////////



#ifndef ERS7_h_DEFINED
#define ERS7_h_DEFINED


#define ERS7_NUM_OUTPUTS 47
#define ERS7_NUM_SENSORS 11
#define ERS7_NUM_BUTTONS 11

static const char* const ERS7_OUTPUTS[] = {

	"lflJoint1",       
	"lflJoint2",    
	"lflJoint3",
	
	"rflJoint1",       
	"rflJoint2",    
	"rflJoint3", 
	
	"lrlJoint1",       
	"lrlJoint2",    
	"lrlJoint3", 
	
	"rrlJoint1",       
	"rrlJoint2",    
	"rrlJoint3", 
		
	"headTilt1",       
	"headPan",    
	"headTilt2",
	
	"tailTilt", 	
	"tailPan",
	
	"mouth", 
	
	"led1",
	"led2",
	"led3",
	"led4",
	"led5",
	"led6",
	"led7",
	"led8",
	"led9",
	"led10",
	"led11",
	"led12",
	"led13",
	"led14",
	"led15",
	"led16",
	"led17",
	"led18",
	"led19",
	"led20",
	"led21",
	"led22",
	"led23",
	"led24",
	"led25",
	"led26",
	"led27",

	"leftEar",
	"rightEar"
	
};

static const char* const ERS7_SENSORS[] = {
	"nearIRDist",
	"farIRDist",  		//!< in millimeters, ranges from 200 to 1500
	"chestIRDist",  	//!< in millimeters, ranges from 100 to 900
	"bAccel", 		//!< backward acceleration, in @f$m/s^2@f$, negative if sitting on butt (positive for faceplant)
	"lAccel", 		//!< acceleration to the robot's left, in @f$m/s^2@f$, negative if lying on robot's left side
	"dAccel", 		//!< downward acceleration, in @f$m/s^2@f$, negative if standing up... be careful about the signs on all of these...
	"powerRemain", 		//!< percentage, 0-1
	"powerThermo", 		//!<  degrees Celcius
	"powerCapacity", 	//!< milli-amp hours
	"powerVoltage", 	//!< volts
	"powerCurrent"		//!< milli-amp negative values (maybe positive while charging?)
};

static const char* const ERS7_BUTTONS[] = {
	"lfPaw",
	"rfPaw",
	"lrPaw",
	"rrPaw",
	"chin",
	"head",
	"fHead",
	"fBack",
	"mBack",
	"rBack",
	"wirelessSwitch"
};      

struct AngleArray{
	int angles[ERS7_NUM_OUTPUTS];
};

enum SensorDataType{
	ACCELERATION,
	ANGULAR_VELOCITY,
	TEMPERATURE,
	FORCE,
	PRESSURE,
	LENGTH,
	SWITCH_STATUS,
	JOINT_VALUE
};

struct ServoGain{
	word Pgain;
	word Igain;
	word Dgain;
};

struct JointRange{
	int min;
	int max;
};

static const word   PSHIFT   = 0x000e;
static const word   ISHIFT   = 0x0002;
static const word   DSHIFT   = 0x000f;



static const char* const ERS7_SENSOR_NAME[] = {
 
	// BODY
	"accelFrontBack",                	// ACCELEROMETER Y
	"accelRightLeft",                	// ACCELEROMETER X
	"accelUpDown",                		// ACCELEROMETER Z
	"chestDistance",                	// BODY PSD
	"wlanSwitch",                		// WIRELESS LAN SWITCH
	"backRear",                		// BACK SENSOR (FRONT)
	"backMiddle",           		// BACK SENSOR (MIDDLE)
	"backFront",             		// BACK SENSOR (REAR)

	// HEAD
	"head",     				// HEAD SENSOR
	"chinSwitch", 				// CHIN SWITCH
	"headDistanceNear",     		// HEAD PSD (NEAR)
	"headDistanceFar",    			// HEAD PSD (FAR)
	"neckTilt1",             		// HEAD TILT1
	"neckPan",          			// HEAD PAN
	"neckTilt2",        			// HEAD TILT2
	"mouth",    				// MOUTH

	// RFLEG (Right Front Leg)
	"rflJoint1",              		// RFLEG J1
	"rflJoint2",          			// RFLEG J2
	"rflJoint3",        			// RFLEG J3
	"rflSwitch",    			// RFLEG SW

	// LFLEG (Left Front Leg)
	"lflJoint1",             		// LFLEG J1
	"lflJoint2",          			// LFLEG J2
	"lflJoint3",        			// LFLEG J3
	"lflSwitch",    			// LFLEG SW 

	// RRLEG (Right Rear Leg)
	"rrlJoint1",             		// RRLEG J1
	"rrlJoint2",          			// RRLEG J2
	"rrlJoint3",        			// RRLEG J3
	"rrlSwitch",    			// RRLEG SW

	// LRLEG (Left Rear Leg)
	"lrlJoint1",             		// LRLEG J1
	"lrlJoint2",          			// LRLEG J2
	"lrlJoint3",        			// LRLEG J3
	"lrlSwitch",    			// LRLEG SW

	// TAIL CPC
	"tailPan",              		// TAIL PAN
	"tailTilt"              		// TAIL TILT
};


static const int ERS7_SENSOR_TYPE[] = {
 
	// BODY
	ACCELERATION,                		// ACCELEROMETER Y
	ACCELERATION,                		// ACCELEROMETER X
	ACCELERATION,                		// ACCELEROMETER Z
	LENGTH,                				// BODY PSD
	SWITCH_STATUS,                		// WIRELESS LAN SWITCH
	PRESSURE,                			// BACK SENSOR (FRONT)
	PRESSURE,           		    	// BACK SENSOR (MIDDLE)
	PRESSURE,             		  		// BACK SENSOR (REAR)

	// HEAD
	PRESSURE,     						// HEAD SENSOR
	SWITCH_STATUS, 						// CHIN SWITCH
	LENGTH,     						// HEAD PSD (NEAR)
	LENGTH,    							// HEAD PSD (FAR)
	JOINT_VALUE,             			// HEAD TILT1
	JOINT_VALUE,          				// HEAD PAN
	JOINT_VALUE,        				// HEAD TILT2
	JOINT_VALUE,    					// MOUTH

	// RFLEG (Right Front Leg)
	JOINT_VALUE,              			// RFLEG J1
	JOINT_VALUE,          				// RFLEG J2
	JOINT_VALUE,        				// RFLEG J3
	SWITCH_STATUS,    					// RFLEG SW

	// LFLEG (Left Front Leg)
	JOINT_VALUE,             			// LFLEG J1
	JOINT_VALUE,          				// LFLEG J2
	JOINT_VALUE,        				// LFLEG J3
	SWITCH_STATUS,    					// LFLEG SW 

	// RRLEG (Right Rear Leg)
	JOINT_VALUE,             			// RRLEG J1
	JOINT_VALUE,          				// RRLEG J2
	JOINT_VALUE,        				// RRLEG J3
	SWITCH_STATUS,    					// RRLEG SW

	// LRLEG (Left Rear Leg)
	JOINT_VALUE,             			// LRLEG J1
	JOINT_VALUE,          				// LRLEG J2
	JOINT_VALUE,        				// LRLEG J3
	SWITCH_STATUS,    					// LRLEG SW

	// TAIL CPC
	JOINT_VALUE,              			// TAIL PAN
	JOINT_VALUE             			// TAIL TILT
};


static const char* const ERS7_SENSOR_LOCATOR[] = {
 
	// BODY
	"PRM:/a1-Sensor:a1",                // ACCELEROMETER Y
	"PRM:/a2-Sensor:a2",                // ACCELEROMETER X
	"PRM:/a3-Sensor:a3",                // ACCELEROMETER Z
	"PRM:/p1-Sensor:p1",                // BODY PSD
	"PRM:/b1-Sensor:b1",                // WIRELESS LAN SWITCH
	"PRM:/t2-Sensor:t2",                // BACK SENSOR (FRONT)
	"PRM:/t3-Sensor:t3",                // BACK SENSOR (MIDDLE)
	"PRM:/t4-Sensor:t4",                // BACK SENSOR (REAR)

	// HEAD
	"PRM:/r1/c1/c2/c3/t1-Sensor:t1",    // HEAD SENSOR
	"PRM:/r1/c1/c2/c3/c4/s5-Sensor:s5", // CHIN SWITCH
	"PRM:/r1/c1/c2/c3/p1-Sensor:p1",    // HEAD PSD (NEAR)
	"PRM:/r1/c1/c2/c3/p2-Sensor:p2",    // HEAD PSD (FAR)
	"PRM:/r1/c1-Joint2:11",             // HEAD TILT1
	"PRM:/r1/c1/c2-Joint2:12",          // HEAD PAN
	"PRM:/r1/c1/c2/c3-Joint2:13",       // HEAD TILT2
	"PRM:/r1/c1/c2/c3/c4-Joint2:14",    // MOUTH

	// RFLEG (Right Front Leg)
	"PRM:/r4/c1-Joint2:41",             // RFLEG J1
	"PRM:/r4/c1/c2-Joint2:42",          // RFLEG J2
	"PRM:/r4/c1/c2/c3-Joint2:43",       // RFLEG J3
	"PRM:/r4/c1/c2/c3/c4-Sensor:44",    // RFLEG SW

	// LFLEG (Left Front Leg)
	"PRM:/r2/c1-Joint2:21",             // LFLEG J1
	"PRM:/r2/c1/c2-Joint2:22",          // LFLEG J2
	"PRM:/r2/c1/c2/c3-Joint2:23",       // LFLEG J3
	"PRM:/r2/c1/c2/c3/c4-Sensor:24",    // LFLEG SW 

	// RRLEG (Right Rear Leg)
	"PRM:/r5/c1-Joint2:51",             // RRLEG J1
	"PRM:/r5/c1/c2-Joint2:52",          // RRLEG J2
	"PRM:/r5/c1/c2/c3-Joint2:53",       // RRLEG J3
	"PRM:/r5/c1/c2/c3/c4-Sensor:54",    // RRLEG SW

	// LRLEG (Left Rear Leg)
	"PRM:/r3/c1-Joint2:31",             // LRLEG J1
	"PRM:/r3/c1/c2-Joint2:32",          // LRLEG J2
	"PRM:/r3/c1/c2/c3-Joint2:33",       // LRLEG J3
	"PRM:/r3/c1/c2/c3/c4-Sensor:34",    // LRLEG SW

	// TAIL CPC
	"PRM:/r6/c1-Joint2:61",             // TAIL PAN
	"PRM:/r6/c2-Joint2:62"              // TAIL TILT
};


static const char* const ERS7_JOINT_NAME[] = {
	"rflJoint1",       
	"rflJoint2",    
	"rflJoint3", 

	"lflJoint1",       
	"lflJoint2",    
	"lflJoint3", 

	"rrlJoint1",       
	"rrlJoint2",    
	"rrlJoint3", 

	"lrlJoint1",       
	"lrlJoint2",    
	"lrlJoint3", 
	
	"neckTilt1",       
	"neckPan",    
	"neckTilt2", 
	
	"tailTilt", 	
	"tailPan",  	  
	
	"mouth"

};

static const char* const ERS7_JOINT_LOCATOR[] = {

	"PRM:/r1/c1-Joint2:11",       // TILT1
	"PRM:/r1/c1/c2-Joint2:12",    // PAN
	"PRM:/r1/c1/c2/c3-Joint2:13", // TILT2
	"PRM:/r1/c1/c2/c3/c4-Joint2:14", // MOUTH

//     "PRM:/r1/c1/c2/c3/e5-Joint4:15", // LEFT EAR
//     "PRM:/r1/c1/c2/c3/e6-Joint4:16", // RIGHT EAR
	
	"PRM:/r4/c1-Joint2:41",       // RFLEG J1 (Right Front Leg)
	"PRM:/r4/c1/c2-Joint2:42",    // RFLEG J2
	"PRM:/r4/c1/c2/c3-Joint2:43", // RFLEG J3

	"PRM:/r2/c1-Joint2:21",       // LFLEG J1 (Left Front Leg)
	"PRM:/r2/c1/c2-Joint2:22",    // LFLEG J2
	"PRM:/r2/c1/c2/c3-Joint2:23", // LFLEG J3

	"PRM:/r5/c1-Joint2:51",       // RRLEG J1 (Right Rear Leg)
	"PRM:/r5/c1/c2-Joint2:52",    // RRLEG J2
	"PRM:/r5/c1/c2/c3-Joint2:53", // RRLEG J3

	"PRM:/r3/c1-Joint2:31",       // LRLEG J1 (Left Rear Leg)
	"PRM:/r3/c1/c2-Joint2:32",    // LRLEG J2
	"PRM:/r3/c1/c2/c3-Joint2:33", // LRLEG J3
	"PRM:/r6/c1-Joint2:61",       // TAIL TILT
	"PRM:/r6/c2-Joint2:62"        // TAIL PAN

};

static const struct ServoGain ERS7_JOINT_GAIN[] = {

	{0x000a, 0x0004, 0x0002},
	{0x0008, 0x0002, 0x0004},
	{0x0008, 0x0004, 0x0002},
	{0x0008, 0x0000, 0x0004},	

	// leftEar
	// rightEar

	{0x0010, 0x0004, 0x0001},
	{0x000a, 0x0004, 0x0001},
	{0x0010, 0x0004, 0x0001},
	
	{0x0010, 0x0004, 0x0001},
	{0x000a, 0x0004, 0x0001},
	{0x0010, 0x0004, 0x0001},
	
	{0x0010, 0x0004, 0x0001},
	{0x000a, 0x0004, 0x0001},
	{0x0010, 0x0004, 0x0001},
	
	{0x0010, 0x0004, 0x0001},
	{0x000a, 0x0004, 0x0001},
	{0x0010, 0x0004, 0x0001},
	
	{0x000a, 0x0004, 0x0004},
	{0x000a, 0x0004, 0x0004}
		
};


static const struct JointRange ERS7_JOINT_RANGE[] = {
	{-115, 130},
	{ -10,  88},
	{ -25, 122},

	{-115, 130},
	{ -10,  88},
	{ -25, 122},

	{-130, 115},
	{ -10,  88},
	{ -25, 122},

	{-130, 115},
	{ -10,  88},
	{ -25, 122},
	
	{ -75,   0},
	{ -88,  88},
	{ -15,  45},
	
	{   5,  60},
	{ -45,  45},
	
	{ -55,  -3}
	
};


static const float ERS7_MAX_SPEED[] = {
	4.86510529e-3, 	// rfLegs LR,FB,REK
	5.27962099e-3,
	5.27962099e-3,
	
	4.86510529e-3,	// lfLeg
	5.27962099e-3,
	5.27962099e-3,
	
	4.86510529e-3,	// rrLeg
	5.27962099e-3,
	5.27962099e-3,
	
	4.86510529e-3,	// lrLeg
	5.27962099e-3,
	5.27962099e-3,
	
	3.18522588e-3, 	// neckTilt1
	1.00574598e-2,	// neckPan
	5.78140315e-3,	// neckTilt2
	
	1.51625479e-2, 	// tailTilt
	1.51625479e-2,	// tailPan
	
	1.01447263e-2 	// mouth
	
};

#endif



