/********************************************************************
             A Golog/Prolog - Tekkotsu Interface
                        August, 2006.                 

            Do not distribute without permission.
            Include this notice in any copy made.

Permission to use, copy, and modify this software and its documentation 
for non-commercial research purpose is hereby granted without fee,
provided that this permission notice appears in all copies. This
software cannot be used for commercial purposes without written permission.
This software is provided "as is" without express or implied warranty
(including all implied warranties of merchantability and fitness).
No liability is implied for any damages resulting from 
or in connection with the use or performance of this software.

E-mail questions/comments about the interface to Huy Pham:
            hpham [at] scs [dot] ryerson [dot] ca   

Implementation environment:
This interface requires Eclipse Prolog:
	http://eclipse.crosscoreop.com/eclipse/index.html

**********************************************************************/




:- ["ERS7.ecl"].

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% Load, link and define external predicates
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- load("aibopred.so").

:- external(resetTime/0, reset_time).

:- external(querySensors/3, query_sensors).
:- external(queryBall/6, query_ball).
:- external(searchBall/3, search_ball).

:- external(postJointCmds/2, post_joint_cmds).
:- external(postMotionCmd/2, post_motion_cmd).

:- external(postSoundCmd/2, post_sound_cmd).

:- external(postWalkCmd/3, post_walk_cmd).
:- external(postStartWalkCmd/3, post_startwalk_cmd).
:- external(postEndWalkCmd/1, post_endwalk_cmd).
:- external(postTurnCmd/2, post_turn_cmd).
:- external(postStartTurnCmd/2, post_startturn_cmd).
:- external(postEndTurnCmd/1, post_endturn_cmd).

:- external(gtidebug/0, gti_debug).

% 
% querySensors([s1, s2, ..., sn], ListOfVals, time)
%
doReally(querySensors(Sensors, Values, Time)):-
	querySensors(Sensors, Values, Time).

% 
% queryBall(Color, Visible, Xcoord, Ycoord, Area, time)
% 
doReally(queryBall(Color, Visible, Xcoord, Ycoord, Area, Time)):-
	ballIndex(Color, Idx),
	queryBall(Idx, Visible, Xcoord, Ycoord, Area, Time).

% 
% searchBall(Color, Found, Xcoord, Ycoord, Area, Time)
% 
doReally(searchBall(Color, Found, Time)):-
	ballIndex(Color, Idx),
	searchBall(Idx, Found, Time).

%
% moveJoints([[j1, a1], [j2,a2], ..., [jn, an]], T)
%
doReally(moveJoints(List, T)):-
	postJointCmds(List, T). 

% 
% motion("filename.mot", time)
% 
doReally(motion(File, T)):-
	postMotionCmd(File, T).

% 
% playSound("filename.wav", time)
% 
doReally(playSound(File, T)):-
	postSoundCmd(File, T).

% 
% walk(dx, dy, t)
% 
doReally(walk(X, Y, T)):-
	postWalkCmd(X, Y, T).

doReally(startWalk(X, Y, T)):-
	postStartWalkCmd(X, Y, T).

doReally(endWalk(T)):-
	postEndWalkCmd(T).

% 
% turn(da, t)
% 
doReally(turn(A, T)):-
	postTurnCmd(A, T).

doReally(startTurn(A, T)):-
	postStartTurnCmd(A, T).

doReally(endTurn(T)):-
	postEndTurnCmd(T).
                      

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% Some Examples
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% :- nl, nl.
% :- writeln("doReally(querySensors([lflJoint1, lflJoint2, lflJoint3], L, 1)).").
% :- writeln("doReally(queryBall(pink, Visible, X, Y, Area, 1)).").
% :- writeln("doReally(searchBall(pink, Found, 1)).").
% :- nl.
% :- writeln("doReally(moveJoints([[lflJoint1, 10], [lflJoint2, 20]], 1)).").
% :- writeln("doReally(motion(\"getrdy.mot\", 1)).").
% :- writeln("doReally(playSound(\"barkhigh.wav\", 1)).").
% :- nl.
% :- writeln("doReally(walk(500, 0, 1)).").
% :- writeln("doReally(startWalk(50, 0, 1)).").
% :- writeln("doReally(endWalk(1)).").
% :- nl.
% :- writeln("doReally(turn(90, 1)).").
% :- writeln("doReally(startTurn(30, 1)).").
% :- writeln("doReally(endTurn(1)).").
% :- nl.
% :- writeln("calcAngle(A).").
% :- nl, nl.



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% Get to the ready-to-walk posture
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% :- doReally(motion("getrdy.mot", 1)).

